#!/bin/sh
# TODO: may be change this such that the user provide CNA directory
echo "Enter the directory where you want to install visualCNA"
echo "In case you already have installed CNA before, give the root directory of CNA"
echo "e.g. if CNA executable is located as /home/user/src/CNA/CNA.sh, then "
echo "Provide /home/user/src as the installation directory"
echo "If you do not have CNA installed, then provide installtion_directory."
echo "visualCNA will be installed as installation_directory/CNA/visualCNA"
echo "Type installation_directory name and press enter"
echo 
read INSTALL_DIR
CUR_DIR=$(pwd)

if [ ! -d "$INSTALL_DIR" ]; then
    echo "Directory $INSTALL_DIR not found, exiting..."
    exit 1
fi

if [ -d "$INSTALL_DIR/CNA" ]; then
    if [ -x "$INSTALL_DIR/CNA/ext/bin/python" ]; then
        # CNA found
        echo "CNA found installed in the directory $INSTALL_DIR"
        echo "The visualCNA will be installed in the same directory"
        echo "Is this OK? [Yes/No]"
        read -e continue
        if [ "$continue" == "Yes" ] || [ "$continue" == "yes" ] || [ "$continue" == "Y" ] || [ "$continue" == "y" ]; then
            cd ${CUR_DIR}/ext
            echo "Installing visualCNA in $INSTALL_DIR/CNA"
            /usr/bin/make INSTALL_DIR=${INSTALL_DIR}/CNA minimal
            # install VisualCNA now
            cp ../visualCNA.py ${INSTALL_DIR}/CNA/ext/lib/python2.7/site-packages/pmg_tk/startup
            cp -r ../modules ${INSTALL_DIR}/CNA/ext/lib/python2.7/site-packages/pmg_tk/visualCNA_modules
            cp -r ../examples ${INSTALL_DIR}/CNA/visualCNA_examples
            cp ../doc/*pdf ${INSTALL_DIR}/CNA/doc
            cd ${INSTALL_DIR}/CNA
            ln -s ext/pymol/pymol visualCNA
        else
            echo "You chose not to install visualCNA, exiting."
            exit 1
        fi
    else
        # CNA directory found but no proper installation
        echo "CNA directory found in ${INSTALL_DIR}, but not proper installation of CNA found!!! Exiting..."
        exit 1
    fi
else
    # install afresh, no CNA found
    # check is this is the CNA directory wrongly provided as installation_directory
    if [ -x "$INSTALL_DIR/ext/bin/python" ] && [ -x "$INSTALL_DIR/CNA.sh" ]; then
        echo "Seems like you have provided the the CNA directory as the installation_directory."
        echo "Please provide the root directory of CNA"
        echo "e.g. if CNA executable is located as /home/user/src/CNA/CNA.sh, then "
        echo "Provide /home/user/src as the installation directory"
        echo "Exiting...."
        echo
        exit 1
    fi
    # create directory structure
    mkdir -p ${INSTALL_DIR}/CNA/ext/src
    mkdir ${INSTALL_DIR}/CNA/doc
    cd ${CUR_DIR}/ext
    /usr/bin/make INSTALL_DIR=${INSTALL_DIR}/CNA all
    # install VisualCNA now
    cp ../visualCNA.py ${INSTALL_DIR}/CNA/ext/lib/python2.7/site-packages/pmg_tk/startup
    cp -r ../modules ${INSTALL_DIR}/CNA/ext/lib/python2.7/site-packages/pmg_tk/visualCNA_modules
    cp -r ../examples ${INSTALL_DIR}/CNA/visualCNA_examples
    cp ../doc/*pdf ${INSTALL_DIR}/CNA/doc
    cd ${INSTALL_DIR}/CNA    
    ln -s ext/pymol/pymol visualCNA
fi
exit
