"""
    Created Mar 2014
    This file is part of VisualCNA
    Copyright (2014) Prakash Chandra Rathi and Daniel Mulnaes

    VisualCNA is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    VisualCNA is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
#####################################################################
# -*- coding: utf-8 -*-
#
# Authors: Daniel Mulnaes and Prakash Chandra Rathi
# Heinrich Heine University, Duesseldorf
# Institute for Pharmaceutical and Medicinal Chemistry
# Universitaetsstr. 1 40225 Duesseldorf
# Germany
#####################################################################


import site

angstrom=u"\N{ANGSTROM SIGN}"

class analyze_setup:
    cna_default=0
    aic_default=False
    fnc_default=100
    fnc_range=(5, 3000)
    aic_descrip='Single or double sigmoid fit for CCE2 transition is based on Akaike Information Criteria'
    cna_types=('SNT Analysis', 'ENT Analysis', 'FNC Analysis')
    cna_descrip=('Thermal unfolding simulation on a single network\ncreated from a single input structure',
                 'Thermal unfolding simulation on an ensemble of\nnetworks created from an ensemble of input structures',
                 'Thermal unfolding simulation on an ensemble of\nnetworks created from a single input structure')
    tus_default=0
    tet_default=1
    tus_types=('TUS Type 1', 'TUS Type 2')
    tet_types=('H0', 'H1', 'H2', 'H3')
    tus_descrip=('The number of hydrophobic constraints\nremain constant during simulation',
                 'The number of hydrophobic constraints\nincreases with increasing temperature')
    tet_descrip=('Do not place any hydophobic tethers',
                 'Place hydrophobic tethers between any atom-pair\nwithin a 0.25 '+angstrom+' cut-off if both atoms are C or S',
                 'Place hydrophobic tethers between any atom-pair within a 0.25 '+angstrom+'\ncut-off if both atoms are C or S and are only bonded to C,S or H',
                 'Place at most 1 hydrophobic tether between any two residues and atom-pairs\nwithin a 0.25 '+angstrom+' cut-off if both atoms are C or S and are only bonded to C,S or H')
    trs_default=2
    nuc_types=('Type 1', 'Type 2', 'Type 3', 'Type 4')
    trs_types=('CCE1 Spline', 'CCE2 Spline', 'CCE2 Sigmoid', 'ROP1 Spline', 'ROP2 Spline', 'ROP3 Spline')
    nuc_defaults=(True, True, True, True)
    nuc_descrip=('Type 1', 'Type 2', 'Type 3', 'Type 4')
    trs_descrip=('Determine transition point from a CCE1 Spline fit',
                 'Determine transition point from a CCE2 Spline fit',
                 'Determine transition point from a CCE2 Sigmoid fit',
                 'Determine transition point from a ROP1 Spline fit',
                 'Determine transition point from a ROP2 Spline fit',
                 'Determine transition point from a ROP3 Spline fit')
    hb_cut_defaults=(-0.1,-6.0, 0.1)
    hb_step_range=(0.05, 0.2)
    hb_start_range=(-2.0, 0)
    hb_stop_range=(-10.0,-5.0)
    hp_start_range=(0.25, 0.40)
    hp_stop_range=(0.40, 0.50)
    hp_cut_defaults=(0.25, 0.40)
    output_defaults=(True, False, False, False)
    barnum_defaults={'HB':5, 'SB':5, 'HP':2, 'CV':5, 'SR':3}
    vdw_radii={'C':1.7, 'S':1.8}

class tooltips:
    # Tooltips for analysis panel
    analysis_type='Select the type of Constraint Network Analysis to be used:\n'+\
                  'A brief description of the analysis is shown to the left'
    pdb_input_file='Select structure input file for CNA.\n'+\
                   'Enabled if structure input is set to File.'
    pdb_input_drop='Select structure input type for CNA:\n'+\
                   'This can be a structure loaded in PyMol\n'+\
                   'or a File specified by clicking PDB File'
    net_input_file='Select network input file for CNA.\n'+\
                   'Enabled if network input is set to File.'
    net_input_drop='Select network input type for CNA:\n'+\
                   'If set to None, CNA will determine the network.\n'+\
                   'If set to File, an input Network file can be specified.\n'+\
                   'If the structure input is a PyMol object and input type\n'+\
                   'is set to PyMol, the current PyMol network is used.'
    unfolding_type='Select the type of thermal unfolding simulation to be used:\n'+\
                   'A brief description of the simulation type is shown to the left'
    tether_placing='Select the criteria for placing hydrophobic tethers between atoms:\n'+\
                   'A brief description of the placement methods is shown to the left'
    akaike_info='Use the Akaike Information Criteria to decide\n'+\
                'if a single or double sigmoid fit of CCE2 should\n'+\
                'be used for detecting the phase-transition point'
    fnc_networks='Select the number of fuzzy networks to be generated'
    hb_step_size='Select the energy cut-off step size for dilution of hydrogen bonds:\n'+\
                 'Minimum %.2f Maximum %.2f (Click button to re-set to default)'%analyze_setup.hb_step_range
    hb_step_min='Select the initial energy for dilution of hydrogen bonds:\n'+\
                'Minimum %.2f Maximum %.2f (Click button to re-set to default)'%analyze_setup.hb_start_range
    hb_step_max='Select the terminal energy for dilution of hydrogen bonds:\n'+\
                'Minimum %.2f Maximum %.2f (Click button to re-set to default)'%analyze_setup.hb_stop_range
    hp_step_min='Select the initial distance for detection of hydrophobic tethers:\n'+\
                'Minimum %.2f Maximum %.2f (Click button to re-set to default)'%analyze_setup.hp_start_range
    hp_step_max='Select the terminal distance for detection of hydrophobic tethers:\n'+\
                'Minimum %.2f Maximum %.2f (Click button to re-set to default)'%analyze_setup.hp_stop_range
    unfolding_1='Unfolding Nuclei Type 1: Residues in the largest rigid\n'+\
                'cluster that becomes flexible at the phase transition'
    unfolding_2='Unfolding Nuclei Type 2: Residues in rigid clusters of\n'+\
                '>30 atoms that becomes flexible at the phase transition'
    unfolding_3='Unfolding Nuclei Type 3: Residues that make critical\n'+\
                'hydrogen bonds which breaks at the phase transition'
    unfolding_4='Unfolding Nuclei Type 4: Residues within a 5.0 A radius of\n'+\
                'hydrogen bonds that break at the phase transition'
    transitions='Select the function fitting method and the global index\n'+\
                'type to be used to determine the phase transition point.\n'+\
                'A brief description of the method is shown to the left'
    set_output1='Write the stability map to an output file'
    set_output2='Write ligand structures to a Mol2 file'
    set_output3='Write the local and global indices for every\n'+\
                'structure or fuzzy network to a file.\n'+\
                'Enabled for ENT and FNC simulations'
    set_output4='Write the network used for each ensemble\n'+\
                'structure (ENT) or fuzzy network (FNC) used.'
    set_out_dir='Select output directory where data from simulation is saved'
    run_cna_now='Click here to start a CNA simulation'

    # Tooltips for Results panel
    set_datadir='Select the directory from which you want to visualize data,\n'+\
                'this will automatically detect all data files in that directory'
    gi_loader='Load an additional global index file to the plot'
    gi_select='Select which global indices to display'
    gi_display='Select which global index files to display (Maximum 7 files)'
    li_loader='Load an additional local index file to the plot'
    li_select='Select which local indices to display'
    li_display='Select which local index files to display (Maximum 7 files)'
    stb_loader='Load an additional stability map file to the plot'
    stb_display='Select which stability maps to display.\n'+\
                'Maximum 2 files can be displayed at a time.\n'+\
                'If two files are on display, the difference\n'+\
                'map between the two is calculated and shown'
    unf_loader='Load an additional unfolding nuclei file to the plot'
    unf_select='Select which unfolding nuclei type to display'
    unf_display='Select which unfolding nuclei files to display\n'+\
                'Maximum 1 file can be displayed at a time.'
    show_pdb='Select a .pdb file to vizualize'
    show_net='Select network file to vizualize'
    show_net_drop='Select structure input to vizualize'
    show_pdb_drop='Select network input to vizualize'
    plot_home='Return plot to original zoom/pan levels'
    plot_pan='Activate Pan mode'
    plot_zoom='Activate Zoom mode'
    plot_save='Save plot to a file'
    add_datas='Add loaded data to existing plots'
    visualize='Visualize data of all selected files'
    set_state='Change state and energy cut-off for display\n'+\
              'of hydrogen bonds and hydrophobic tethers'

    # Tooltips for Modify panel
    undo_network_mods='Undo the last change to the network'
    redo_network_mods='Redo the last network change undone'
    pymol_constraints='Add a constraint between two atoms\n'+\
                      'selected in the PyMol session'
    pymol_deletion='Delete a constraint between two atoms\n'+\
                      'selected in the PyMol session'
    select_pymol_type='Select the type of constraint to be\n'+\
                      'created in PyMol'
    select_pymol_bars='Select the number of bars for the\n'+\
                      'constraint you want to create'
    table_constraints='Add a constraint between two atoms\n'+\
                      'with ID\'s written to the right'
    select_table_type='Select the type of constraint to be\n'+\
                      'displayed in the table below'
    select_table_bars='Select the number of bars for the\n'+\
                      'constraint you want to create'
    set_table_atoms_1='Write atom ID of the first atom of\n'+\
                      'the constraint you want to create'
    set_table_atoms_2='Write atom ID of the second atom of\n'+\
                      'the constraint you want to create'
    search_query_word='Enter constraint search term'
    search_query_last='Find previous occurence of the search term'
    search_query_next='Find next occurence of the search term'
    save_network_file='Save the current network to a network file'

    # Tooltips for Mutate panel
    open_reference_dir='Directory of reference data e.g. wiltype data'
    open_comparison_dir='Directory of comparison data e.g. mutant data'
    msa_loader='Change between the loaded multiple sequence alignment files'
    msa_display='Select which multiple sequence alignment file to display\n'+\
                'Maximum 1 file can be displayed at a time.'
    sequence_name='Name of the loaded proteins sequence in the alignment'
    chain_id_name='Name of the loaded proteins chain id in the alignment'
    open_msa_file='Load an additional multiple sequence alignment to the plot'
    compare_pairs='Compare the results of mutant and wildtype networks\n'+\
                  'Missing data will be generated by the type of CNA\n'+\
                  'simulation specified in the right-hand side drop-down'
    compare_type='Type of CNA simulation used for comparison,\n'+\
                 'specific settings will be taken from the Setup panel'

class results_setup:
    CNA_HOME = site.getsitepackages()[0].split('ext')[0]
    example_dir=CNA_HOME+'visualCNA_examples/'
    # Set defaults as show-case examples for Global and Local Indices
    logo_image=site.getsitepackages()[0]+'/pmg_tk/visualCNA_modules/visual_cna_logo.gif'
    pdb_file=example_dir+'1I6W_snt/1I6W_prepared_modified.pdb'
    net_file=example_dir+'1I6W_snt/1I6W_prepared_network.dat'
    gi_file=example_dir+'1I6W_snt/1I6W_prepared_global_indices.dat'
    li_file=example_dir+'1I6W_snt/1I6W_prepared_local_indices.dat'
    stb_file=example_dir+'1I6W_snt/1I6W_prepared_stability_map.dat'
    unf_file=example_dir+'1I6W_snt/1I6W_prepared_unfolding_nuclei.dat'
    msa_file=example_dir+'lipA_msa/lipA_msa.clustal'
    msa_name='ESTA_BACSU'
    msa_chain='A'

    cna_default="single"
    tus_default=1
    hb_cut_defaults=(-0.1,-6.0, 0.1)
    hp_cut_defaults=(0.25, 0.40)
