"""
    Created Mar 2014
    This file is part of VisualCNA
    Copyright (2014) Prakash Chandra Rathi and Daniel Mulnaes

    VisualCNA is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    VisualCNA is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
#####################################################################
# -*- coding: utf-8 -*-
#
# Authors: Prakash Chandra Rathi and Daniel Mulnaes
# Heinrich Heine University, Duesseldorf
# Institute for Pharmaceutical and Medicinal Chemistry
# Universitaetsstr. 1 40225 Duesseldorf
# Germany
#####################################################################


# Standard python libraries
import tkMessageBox

# TODO: replace numeric ids with some sensible error names so they are easy to remember and do not conflict when two developers are appending new errors.
# Then a dictionary {error_name:error} can be made in the beginning and can be accessed later.

angstrom=u"\N{ANGSTROM SIGN}"

def input_error(error_id, args=None):
    if error_id==0:
        tkMessageBox.showerror('CNA Argument', 'Only '+str(args[0])+' values are allowed!')
    if error_id==1:
        tkMessageBox.showerror('CNA Argument', 'Only values between %.2f and %.2f are allowed!'%args)
    if error_id==2:
        tkMessageBox.showerror('CNA Argument', 'Only integer atom error_id\'s between %d and %d exist!'%args)
    if error_id==3:
        tkMessageBox.showerror('CNA Argument', 'Only integer atom error_id\'s are allowed!')
    if error_id==4:
        tkMessageBox.showerror('Network Error', 'No molecule selected to get FIRST Network from')
    if error_id==5:
        tkMessageBox.showerror('Network Error', 'The selected molecule is not loaded in PyMOL')
    if error_id==6:
        tkMessageBox.showerror('Network Error', 'No PyMOL Network to be used as input')
    if error_id==7:
        tkMessageBox.showerror('Network Error', 'No clusters can be drawn when ShowNetwork has not been initializes with a stb_map')
    if error_id==8:
        tkMessageBox.showerror('Alignment Error', 'Error: sequence in msa and pdb file differ')
    if error_id==9:
        tkMessageBox.showerror('Alignment Error', 'Error: MSA is not in a shape of an m*n matrix (m sequnces of lenth n)')
    if error_id==10:
        tkMessageBox.showerror('Input File', 'Disordered residue(s) in input pdb. Provide only one conformation for all atoms')
    if error_id==11:
        tkMessageBox.showerror('Input File', 'Maximum number of stability maps files allowed is 2')
    if error_id==12:
        tkMessageBox.showerror('Input File', 'File %s not found'%args)
    if error_id==13:
        tkMessageBox.showerror('Input File', 'Missing atoms found in file: %s'%args)
    if error_id==14:
        tkMessageBox.showerror('Input File', 'The file %s does not seem to contain %s data'%args)
    if error_id==15:
        tkMessageBox.showerror('Local Index Load Error', 'Local index file %s does not seem to conform to the pdb file.'%args)
    if error_id==16:
        tkMessageBox.showerror('Global Index Load Error', 'Global index file %s does not seem to conform to hb_cut_offs of the previously loaded CNA results.'%args)
    if error_id==17:
        tkMessageBox.showerror('Stability Map Load Error', 'Stability map file %s does not seem to conform to the pdb file.'%args)
    if error_id==18:
        tkMessageBox.showerror('Unfolding Nuclei Load Error', 'Unfolding nuclei file %s does not seem to conform to the pdb file.'%args)
    if error_id==19:
        tkMessageBox.showerror('Network load Error', 'Network file %s does not seem to conform to the pdb file. Reading network from pdb'%args)
    if error_id==20:
        tkMessageBox.showerror('Runtime Error', 'CNA Encountered an error while running and was terminated, check %s for details'%args)
    if error_id==21:
        tkMessageBox.showerror('PDB Read Error', 'There are encountered some problems while reading %s file. Make sure that all chains are separated by a TER card and all atom names are unique within a single residue'%args)
    if error_id==22:
        tkMessageBox.showerror('Input File', 'Multiple residue conformations found in file: %s'%args)
    if error_id==23:
        tkMessageBox.showerror('Multiple Sequence Alignment Read Error', 'Base sequence "%s" is not found in the MSA file %s.'%args)
    if error_id==24:
        tkMessageBox.showerror('Multiple Sequence Alignment Read Error', '%s file could not be parsed to read MSA with %s format'%args)
    if error_id==25:
        tkMessageBox.showerror('Wild Type PDB Save', 'Wild type pdb is not found in %s directory, click OK to save wild type pdb'%args)
    if error_id==26:
        tkMessageBox.showerror('Molecule not loaded in PyMol', 'The molecule %s in not loaded in Pymol'%args)
    if error_id==27:
        tkMessageBox.showerror('Constraint Error', 'The constraint between atoms %i and %i does not fit the parameters of a %s'%args)
    if error_id==28:
        tkMessageBox.showerror('Comparison Error', 'The number of residues in the two systems are not identical and the systems can not be compared')

def attention(attention_id, args=None):
    if attention_id==0:
        return tkMessageBox.askyesno('Run Complete', 'Your CNA run is done. Results were saved to %s. Do you want to visualize the data?'%args)
    if attention_id==1:
        return tkMessageBox.showinfo('Info', 'Parameter file was not found. Taking cut-off paramters from analyze panel')
    if attention_id==2:
        return tkMessageBox.askokcancel('Confirm Mutation', 'Select rotamer for %s_%s%s to %s in %s by changing the state and then click OK to mutate, else click Cancel'%args)
    if attention_id==3:
        return tkMessageBox.showinfo('Choose Rotamer', 'Choose rotamer for the selected mutation by changing the state and click OK')
    if attention_id==4:
        return tkMessageBox.showinfo('Load File', 'A maximum of %d files can be displayed at a time, untick previous files to view the new file'%args)
    if attention_id==5:
        return tkMessageBox.askyesno('Load Example', 'Welcome to VisualCNA. Do you want to load the example? %s'%args)
    if attention_id==6:
        return tkMessageBox.showinfo('Results missing', '%s not found. The missing results will be generated by running CNA'%args)
    if attention_id==7:
        return tkMessageBox.askyesno('Overwrite Results', 'This will overwrite the results found in %sresults, is that ok?'%args)
    if attention_id==8:
        return tkMessageBox.askyesno('Delete PDB', 'This will delete all constraints, clusters and plots for %s, is that ok?'%args)
    if attention_id==9:
        return tkMessageBox.showinfo('Create Constraint', 'Constraints will only be created when exactly 2 atoms are selected')
    if attention_id==10:
        return tkMessageBox.askyesno('Create Constraint', 'The distance between the selected atoms %i and %i is %.1f '%args+angstrom+', are you sure that these should be constrained?')
    if attention_id==11:
        return tkMessageBox.showinfo('CNA not found', 'CNA is not installed and can therefore not be run')
